<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Recipes extends Model 
{

    protected $table = 'recipes';
    public $timestamps = true;

    public function nutritions()
    {
        return $this->hasMany('App\Models\Nutrition', 'recipe_id');
    }

    public function categories()
    {
        return $this->belongsToMany('App\Models\Category');
    }

    public function ingredients()
    {
        return $this->hasMany('App\Models\Ingredient');
    }

    public function preparations()
    {
        return $this->hasMany('App\Models\Preparation');
    }

    public function reviews()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function tags()
    {
        return $this->hasMany('App\Models\Tag');
    }

    public function images()
    {
        return $this->hasMany('App\Models\RecipeImage');
    }

}